/**
  ******************************************************************************
  * @file    MDR1901VC1_IT.c
  * @author  Milandr Application Team
  * @version V2.0.3
  * @date    12/05/2023
  * @brief   Main Interrupt Service Routines for MCU MDR1901VC1.
  ******************************************************************************
  * <br><br>
  *
  * THE PRESENT FIRMWARE IS FOR GUIDANCE ONLY. IT AIMS AT PROVIDING CUSTOMERS
  * WITH CODING INFORMATION REGARDING MILANDR'S PRODUCTS IN ORDER TO FACILITATE
  * THE USE AND SAVE TIME. MILANDR SHALL NOT BE HELD LIABLE FOR ANY
  * DIRECT, INDIRECT OR CONSEQUENTIAL DAMAGES RESULTING
  * FROM THE CONTENT OF SUCH FIRMWARE AND/OR A USE MADE BY CUSTOMERS OF THE
  * CODING INFORMATION CONTAINED HEREIN IN THEIR PRODUCTS.
  *
  * <h2><center>&copy; COPYRIGHT 2024 Milandr</center></h2>
  */

/* Includes ------------------------------------------------------------------*/
#include "MDR1901VC1_IT.h"

/** @addtogroup __MDR32Fx_StdPeriph_Driver MDR32Fx Standard Peripherial Driver
  * @{
  */

/** @defgroup MDR1901VC1_IT MDR1901VC1 IT
  * @{
  */

#if defined (USE_MDR1901VC1T)

#if defined (_USE_DEBUG_UART_)

/** @defgroup MDR1901VC1_IT_Private_Defines MDR1901VC1 IT Private Defines
  * @{
  */
#define DEBUG_PRINTF(...) printf(__VA_ARGS__)

/** @} */ /* End of group MDR1901VC1_IT_Private_Defines */

/** @defgroup MDR1901VC1_IT_Private_Function_Prototypes MDR1901VC1 IT Private Function Prototypes
  * @{
  */
void Hard_fault_handler_c(unsigned int* hardfault_args);

/** @} */ /* End of group MDR1901VC1_IT_Private_Function_Prototypes */

#endif /* #if defined (_USE_DEBUG_UART_) */

/** @defgroup MDR1901VC1_IT_Exported_Functions MDR1901VC1 IT Exported Functions
  * @{
  */

/**
  * @brief  Hard Fault exception handler.
  * @param  None
  * @retval None
  */
void HardFault_Handler(void)
{
#if defined (_USE_DEBUG_UART_)
    unsigned int contr_reg;
    contr_reg = __get_CONTROL();
    if(contr_reg & 2)
    {
#if defined ( __CMCARM__ )
        __ASM MRS R0, PSP;
#else
        __ASM("MRS R0, PSP");
#endif
    }
    else
    {
#if defined ( __CMCARM__ )
        __ASM MRS R0, MSP;
#else
        __ASM("MRS R0, MSP");
#endif
    }
    //top of stack is in R0. It is passed to C-function.
#if defined ( __CMCARM__ )
    __ASM BL (Hard_fault_handler_c);
#else
    __ASM("BL (Hard_fault_handler_c)");
#endif

#endif /* #if defined (_USE_DEBUG_UART_) */

    /* Go to infinite loop when Hard Fault exception occurs */
    while (1);
}

/**
  * @brief  Memory Mamagement Fault exception handler.
  * @param  None
  * @retval None
  */
void MemoryManagement_Handler(void)
{
}

/**
  * @brief  Bus Fault Handler exception.
  * @param  None
  * @retval None
  */
void BusFault_Handler(void)
{
}

/**
  * @brief  Usage Fault exception handler.
  * @param  None
  * @retval None
  */
void UsageFault_Handler(void)
{
}

/**
  * @brief  SVCall exception handler.
  * @param  None
  * @retval None
  */
void SVCall_Handler(void)
{
}

/**
  * @brief  Debug PendSV exception handler.
  * @param  None
  * @retval None
  */
void PendSV_Handler(void)
{
}

/**
  * @brief  SysTick handler.
  * @param  None
  * @retval None
  */
void SysTick_Handler(void)
{
}


/**
  * @brief  SSP3 interrupt request handler.
  * @param  None
  * @retval None
  */
void SSP3_IRQHandler(void)
{
}

/**
  * @brief  SSP4 interrupt request handler.
  * @param  None
  * @retval None
  */
void SSP4_IRQHandler(void)
{
}

/**
  * @brief  USB interrupt request handler.
  * @param  None
  * @retval None
  */
void USB_IRQHandler(void)
{
}

/**
  * @brief  MCBSP1 interrupt request handler.
  * @param  None
  * @retval None
  */
void MCBSP1_IRQHandler(void)
{
}

/**
  * @brief  MCBSP2 interrupt request handler.
  * @param  None
  * @retval None
  */
void MCBSP2_IRQHandler(void)
{
}

/**
  * @brief  DMA interrupt request handler.
  * @param  None
  * @retval None
  */
void DMA_IRQHandler(void)
{
}

/**
  * @brief  UART1 interrupt request handler.
  * @param  None
  * @retval None
  */
void UART1_IRQHandler(void)
{
}

/**
  * @brief  UART2 interrupt request handler.
  * @param  None
  * @retval None
  */
void UART2_IRQHandler(void)
{
}

/**
  * @brief  SSP1 interrupt request handler.
  * @param  None
  * @retval None
  */
void SSP1_IRQHandler(void)
{
}

/**
  * @brief  MCBSP3 interrupt request handler.
  * @param  None
  * @retval None
  */
void MCBSP3_IRQHandler(void)
{
}

/**
  * @brief  I2C interrupt request handler.
  * @param  None
  * @retval None
  */
void I2C_IRQHandler(void)
{
}

/**
  * @brief  POWER interrupt request handler.
  * @param  None
  * @retval None
  */
void POWER_IRQHandler(void)
{
}

/**
  * @brief  WWDG interrupt request handler.
  * @param  None
  * @retval None
  */
void WWDG_IRQHandler(void)
{
}

/**
  * @brief  DMA DSP interrupt request handler.
  * @param  None
  * @retval None
  */
void DMA_DSP_IRQHandler(void)
{
}

/**
  * @brief  TIMER1 interrupt request handler.
  * @param  None
  * @retval None
  */
void TIMER1_IRQHandler(void)
{
}

/**
  * @brief  TIMER2 interrupt request handler.
  * @param  None
  * @retval None
  */
void TIMER2_IRQHandler(void)
{
}

/**
  * @brief  TIMER3 interrupt request handler.
  * @param  None
  * @retval None
  */
void TIMER3_IRQHandler(void)
{
}

/**
  * @brief  ADC interrupt request handler.
  * @param  None
  * @retval None
  */
void ADC_IRQHandler(void)
{
}

/**
  * @brief  SDIO interrupt request handler.
  * @param  None
  * @retval None
  */
void SDIO_IRQHandler(void)
{
}

/**
  * @brief  Comparator interrupt request handler.
  * @param  None
  * @retval None
  */
void COMPARATOR_IRQHandler(void)
{
}

/**
  * @brief  SSP2 interrupt request handler.
  * @param  None
  * @retval None
  */
void SSP2_IRQHandler(void)
{
}

/**
  * @brief  AUDIO_IP interrupt request handler.
  * @param  None
  * @retval None
  */
void AUDIO_IP_IRQHandler(void)
{
}

/**
  * @brief  DSP CRYPTO interrupt request handler.
  * @param  None
  * @retval None
  */
void DSP_CRPT_IRQHandler(void)
{
}

/**
  * @brief  DSP TIMER interrupt request handler.
  * @param  None
  * @retval None
  */
void DSP_TIMER_IRQHandler(void)
{
}

/**
  * @brief  DSP CORE interrupt request handler.
  * @param  None
  * @retval None
  */
void DSP_CORE_IRQHandler(void)
{
}

/**
  * @brief  DSP_STATE interrupt request handler.
  * @param  None
  * @retval None
  */
void DSP_STATE_IRQHandler(void)
{
}

/**
  * @brief  UART3 interrupt request handler.
  * @param  None
  * @retval None
  */
void UART3_IRQHandler(void)
{
}

/**
  * @brief  BKP interrupt request handler.
  * @param  None
  * @retval None
  */
void BACKUP_IRQHandler(void)
{
}

/**
  * @brief  EXT_INT1 interrupt request handler.
  * @param  None
  * @retval None
  */
void EXT_INT1_IRQHandler(void)
{
}

/**
  * @brief  EXT_INT2 interrupt request handler.
  * @param  None
  * @retval None
  */
void EXT_INT2_IRQHandler(void)
{
}

/**
  * @brief  EXT_INT3 interrupt request handler.
  * @param  None
  * @retval None
  */
void EXT_INT3_IRQHandler(void)
{
}

/**
  * @brief  EXT_INT4 interrupt request handler.
  * @param  None
  * @retval None
  */
void EXT_INT4_IRQHandler(void)
{
}

/** @} */ /* End of group MDR1901VC1_IT_Exported_Functions */

/** @defgroup MDR1901VC1_IT_Private_Functions MDR1901VC1 IT Private Functions
  * @{
  */


#if defined (_USE_DEBUG_UART_)
/**
  * @brief  Handles hard fault exception, stores stack and prints stack via UART
  * @param  hardfault_args: MCU stack
  * @retval None
  */
void Hard_fault_handler_c(unsigned int* hardfault_args)
{
    unsigned int stacked_r0;
    unsigned int stacked_r1;
    unsigned int stacked_r2;
    unsigned int stacked_r3;
    unsigned int stacked_r12;
    unsigned int stacked_lr;
    unsigned int stacked_pc;
    unsigned int stacked_psr;

    stacked_r0 = ((unsigned long) hardfault_args[0]);
    stacked_r1 = ((unsigned long) hardfault_args[1]);
    stacked_r2 = ((unsigned long) hardfault_args[2]);
    stacked_r3 = ((unsigned long) hardfault_args[3]);

    stacked_r12 = ((unsigned long) hardfault_args[4]);
    stacked_lr  = ((unsigned long) hardfault_args[5]);
    stacked_pc  = ((unsigned long) hardfault_args[6]);
    stacked_psr = ((unsigned long) hardfault_args[7]);

    DEBUG_PRINTF("[Hard fault handler]\r\n");
    DEBUG_PRINTF("R0 = 0x%x\r\n", stacked_r0);
    DEBUG_PRINTF("R1 = 0x%x\r\n", stacked_r1);
    DEBUG_PRINTF("R2 = 0x%x\r\n", stacked_r2);
    DEBUG_PRINTF("R3 = 0x%x\r\n", stacked_r3);
    DEBUG_PRINTF("R12 = 0x%x\r\n", stacked_r12);
    DEBUG_PRINTF("LR = 0x%x\r\n", stacked_lr);
    DEBUG_PRINTF("PC = 0x%x\r\n", stacked_pc);
    DEBUG_PRINTF("PSR = 0x%x\r\n", stacked_psr);

    /* Go to infinite loop when Hard Fault exception occurs */
    while (1);
}

#endif /* #if defined (_USE_DEBUG_UART_) */

/** @} */ /* End of group MDR1901VC1_IT_Exported_Functions */

#endif /* #if defined (USE_MDR1901VC1T) */

/** @} */ /* End of group MDR1901VC1_IT */

/** @} */ /* End of group __MDR32Fx_StdPeriph_Driver */

/*********************** (C) COPYRIGHT 2024 Milandr ****************************
*
* END OF FILE MDR1901VC1_IT.c */

